package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bConvenios;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bConveniosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaConveniosExcelAction extends Q70ActionPasoOP{


	/**
	 * processOP.
	 *
	 * @param contexto a
	 * @param errores a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}


	/**
	 * processForward.
	 * 
	 * @param contexto a
	 * @param errors a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @return ActionForward
	 * @throws Exception e
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoConvenios.xls";
		InputStream inputStream = W83bTablaConveniosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaConvenios = (ArrayList)contexto.get("w83bListaConvenios");
        W83bConveniosBean convenioBean = (W83bConveniosBean)contexto.get("w83bConveniosTempBean");   
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);   
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);   
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);   
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));   
        HashMap mapaConvenios=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);   
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1   
        HSSFCell cell = row.createCell((short)3);   
        row = sheet.getRow((short)4);   
        cell = row.getCell((short)4);   
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaConvenios.get("tituloDepEs");   
        StringBuffer tituloImagenEu =  (StringBuffer)mapaConvenios.get("tituloDepEu");   
        cell.setCellValue(tituloImagenEu.toString());   
        
        cell = row.getCell((short)9);    
        cell.setCellValue(tituloImagenEs.toString());   
        
        tituloImagenEs = (StringBuffer)mapaConvenios.get("tituloDelelegacionEs");   
        tituloImagenEu = (StringBuffer)mapaConvenios.get("tituloDelelegacionEu");   
        
        row = sheet.getRow((short)6);    
        cell = row.getCell((short)4);   
        cell.setCellValue(tituloImagenEu.toString());   
        
        cell = row.getCell((short)9);   
        cell.setCellValue(tituloImagenEs.toString());   
        
        row = sheet.getRow((short)9);   
        cell = row.getCell((short)0);   
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.listadoConveniosExcel").toUpperCase());   
        
        //MAPEO FORMULARIO
        row = sheet.getRow(Short.parseShort("12")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.codConvenios"));
        cell = row.createCell(Short.parseShort("2")); 
        if(!StringUtils.isEmpty(convenioBean.getCodConvenios())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("2"),W83bClsConstantes.DOCE,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(W83bUtilidades.numero(convenioBean.getCodConvenios()));

        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("4"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.descConvenio"));
        cell = row.getCell(Short.parseShort("7"));
        if(!StringUtils.isEmpty(convenioBean.getDescConvenios())){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("7"),W83bClsConstantes.DOCE,Short.parseShort("15")));//NOPMD
	        cell.setCellValue(convenioBean.getDescConvenios().toUpperCase());
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
	        if(85<(convenioBean.getDescConvenios()).length()){
	    		row.setHeightInPoints((short)(22*((convenioBean.getDescConvenios()).length()/85)+1));
	    	}
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("16"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.espAraba"));
        cell = row.getCell(Short.parseShort("18"));
        if(W83bClsConstantes.CONSTANTE_SI.equals(convenioBean.getEspEnAlava())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
     	
        }else if(W83bClsConstantes.CONSTANTE_NO.equals(convenioBean.getEspEnAlava())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));

        }else{
        	cell.setCellValue("");      	
        }
        
        //siguiente fila
        row = sheet.getRow(Short.parseShort("13")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.tipoEmpresa"));
        cell = row.createCell(Short.parseShort("2"));
        if(!StringUtils.isEmpty(convenioBean.getTipoEmpresaDesc())){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("2"),W83bClsConstantes.TRECE,Short.parseShort("3")));//NOPMD
	        cell.setCellValue(convenioBean.getTipoEmpresaDesc().toUpperCase());
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("4"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.descConvenioEusk"));
        cell = row.getCell(Short.parseShort("7"));
        if(!StringUtils.isEmpty(convenioBean.getDescConveniosEusk())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("7"),W83bClsConstantes.TRECE,Short.parseShort("15")));//NOPMD
	        cell.setCellValue(convenioBean.getDescConveniosEusk().toUpperCase());
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
	        if(85<(convenioBean.getDescConveniosEusk()).length()){
	    		row.setHeightInPoints((short)(22*((convenioBean.getDescConveniosEusk()).length()/85)+1));
	    	}
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("16"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.espGipuzkoa"));
        cell = row.getCell(Short.parseShort("18"));
        if(W83bClsConstantes.CONSTANTE_SI.equals(convenioBean.getEspEnGuip())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));

        }else if(W83bClsConstantes.CONSTANTE_NO.equals(convenioBean.getEspEnGuip())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        	
        }else{
        	cell.setCellValue("");      	
        }
        
        //siguiente fila
        row = sheet.getRow(Short.parseShort("14")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.codMadrid"));
        cell = row.createCell(Short.parseShort("2"));
        if(!StringUtils.isEmpty(convenioBean.getCodMadrid())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("2"),W83bClsConstantes.CATORCE,Short.parseShort("3")));//NOPMD
        	cell.setCellValue(W83bUtilidades.numero(convenioBean.getCodMadrid()));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("4"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.convDiferencias"));
        cell = row.getCell(Short.parseShort("7"));
        if(W83bClsConstantes.CONSTANTE_SI.equals(convenioBean.getConvPorEscrut())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("7"),W83bClsConstantes.CATORCE,Short.parseShort("10")));//NOPMD
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
  	
        }else if(W83bClsConstantes.CONSTANTE_NO.equals(convenioBean.getConvPorEscrut())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("7"),W83bClsConstantes.CATORCE,Short.parseShort("10")));//NOPMD
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
       	
        }else{
        	cell.setCellValue("");      	
        }
        
        cell = row.getCell(Short.parseShort("11"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.herramientas.baja"));
        cell = row.getCell(Short.parseShort("13"));
        if(StringUtils.isEmpty(convenioBean.getBaja())||W83bClsConstantes.CONSTANTE_NO.equals(convenioBean.getBaja())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
       	
        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());
  	        	
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        
        cell = row.getCell(Short.parseShort("16"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.espBizkaia"));
        cell = row.getCell(Short.parseShort("18"));
        if(W83bClsConstantes.CONSTANTE_SI.equals(convenioBean.getEspEnBizkaia())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        	
        }else if(W83bClsConstantes.CONSTANTE_NO.equals(convenioBean.getEspEnBizkaia())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));

        }else{
        	cell.setCellValue("");      	
        }

  
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow(Short.parseShort("17")); // Creacin de la fila 1
        cell = row.getCell(Short.parseShort("0")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.codConvenios"));
        
        cell = row.getCell(Short.parseShort("1")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.tipoEmpresa"));
        
        cell = row.getCell(Short.parseShort("2")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.descConvenio"));
        
        cell = row.getCell(Short.parseShort("5")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.descConvenioEusk"));
        
        cell = row.getCell(Short.parseShort("10")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.convDiferencias"));
        
        cell = row.getCell(Short.parseShort("13")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.espAraba"));
        
        cell = row.getCell(Short.parseShort("16")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.espGipuzkoa"));
        
        cell = row.getCell(Short.parseShort("18")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.espBizkaia"));
        
        
        for(int i=0;i<listaConvenios.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECIOCHO+i); // Creacin de la fila 1//NOPMD
        	
        	//Cod Convenio
        	cell = row.createCell(Short.parseShort("0")); 
        	if(StringUtils.isNotEmpty(((W83bConveniosBean)listaConvenios.get(i)).getCodConvenios())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bConveniosBean)listaConvenios.get(i)).getCodConvenios()));
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFilaNumero(i,excel));
        	
        	//Tipo empresa
        	cell = row.createCell(Short.parseShort("1"));
        	String tipoEmpresa = "";
            	if(StringUtils.isNotEmpty(((W83bConveniosBean)listaConvenios.get(i)).getTipoEmpresa())){
            		tipoEmpresa = ((W83bConveniosBean)listaConvenios.get(i)).getTipoEmpresa();
            	}else{
            		tipoEmpresa = "";
            	}
            if(W83bClsConstantes.CONSTANTE_CASTELLANO.equals(contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA))){
            	if(StringUtils.isNotEmpty(((W83bConveniosBean)listaConvenios.get(i)).getTipoEmpresaDesc())){
            		cell.setCellValue(tipoEmpresa +" - "+ ((W83bConveniosBean)listaConvenios.get(i)).getTipoEmpresaDesc());
            	}else{
            		cell.setCellValue("");
            	}
            	
            }else{
            	if(StringUtils.isNotEmpty(((W83bConveniosBean)listaConvenios.get(i)).getTipoEmpresaDescEusk())){
            		cell.setCellValue(tipoEmpresa +" - "+ ((W83bConveniosBean)listaConvenios.get(i)).getTipoEmpresaDescEusk());
            	}else{
            		cell.setCellValue("");
            	}
            	
            }
//            	if(StringUtils.isNotEmpty(((W83bConveniosBean)listaConvenios.get(i)).getTipoEmpresa())){
//            		cell.setCellValue(((W83bConveniosBean)listaConvenios.get(i)).getTipoEmpresa());
//            	}else{
//            		cell.setCellValue("");
//            	}
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	//Descripcion Convenio
        	cell = row.createCell(Short.parseShort("2"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("2"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("4")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bConveniosBean)listaConvenios.get(i)).getDescConvenios())){
        		cell.setCellValue(((W83bConveniosBean)listaConvenios.get(i)).getDescConvenios());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("3"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("4"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	//Descripcion Convenio Euskera
        	cell = row.createCell(Short.parseShort("5")); 
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("5"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("9")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bConveniosBean)listaConvenios.get(i)).getDescConveniosEusk())){
        		cell.setCellValue(((W83bConveniosBean)listaConvenios.get(i)).getDescConveniosEusk());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("6"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("7"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("8"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("9"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	//conv por estructura
        	cell = row.createCell(Short.parseShort("10"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("10"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("12")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bConveniosBean)listaConvenios.get(i)).getConvPorEscrutStr())){
        		cell.setCellValue(((W83bConveniosBean)listaConvenios.get(i)).getConvPorEscrutStr().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFilaNumero(i,excel));
        	cell = row.createCell(Short.parseShort("11"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("12"));
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	//Especial en lava
        	cell = row.createCell(Short.parseShort("13"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("13"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("15")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bConveniosBean)listaConvenios.get(i)).getEspEnAlavaStr())){
        		cell.setCellValue(((W83bConveniosBean)listaConvenios.get(i)).getEspEnAlavaStr().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumero(i,excel));
        	cell = row.createCell(Short.parseShort("14"));
        	cell.setCellStyle(this.estiloFilaNumero(i,excel));
        	cell = row.createCell(Short.parseShort("15"));
        	cell.setCellStyle(this.estiloFilaNumero(i,excel));
        	
        	//Especial en Guipuzcoa
        	cell = row.createCell(Short.parseShort("16"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("16"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("17")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bConveniosBean)listaConvenios.get(i)).getEspEnGuipStr())){
        		cell.setCellValue(((W83bConveniosBean)listaConvenios.get(i)).getEspEnGuipStr().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumero(i,excel));
        	cell = row.createCell(Short.parseShort("17"));
        	cell.setCellStyle(this.estiloFilaNumero(i,excel));
        	
        	//Especial en Bizkaia
        	cell = row.createCell(Short.parseShort("18"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("18"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("19")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bConveniosBean)listaConvenios.get(i)).getEspEnBizkaiaStr())){
        		cell.setCellValue(((W83bConveniosBean)listaConvenios.get(i)).getEspEnBizkaiaStr().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumero(i,excel));
        	cell = row.createCell(Short.parseShort("19"));
        	cell.setCellStyle(this.estiloFilaNumero(i,excel));
        	

        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoConvenios.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}		
	}

	/**
	 * Estilo fila numero.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumero(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}		
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}
